<?php 
/*
 * ----------------------------------------------
 * Lazarus Guestbook 
 * by Stewart Souter
 * URL: www.carbonize.co.uk 
 * Based on Advanced Guestbook 2.3.x (PHP/MySQL)
 * Copyright (c)2001 Chi Kien Uong
 * URL: http://www.proxy2.de
 * Last Modified: Tue, 6 January 2009 12:31:48 GMT
 * ----------------------------------------------
 */

class gb_comment 
{
  var $comment;
  var $ip;
  var $id;
  var $db;
  var $user;
  var $pass_comment;
  var $template;
  var $path;
  var $bottest;
  var $timehash;
  var $accepted;

  function gb_comment($path = '')
  {
    global $_SERVER, $GB_PG;
    if (isset($_SERVER['HTTP_X_FORWARDED_FOR']) && !empty($_SERVER['HTTP_X_FORWARDED_FOR']) && preg_match('/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/',$_SERVER['HTTP_X_FORWARDED_FOR']) && !preg_match('/^(192\.168\.)|(127\.0\.0\.1)|(10\.)|(169\.((1[2-9])|(2[0-9])|(30)|(31))\.)/', $_SERVER['HTTP_X_FORWARDED_FOR']))
    {
      $this->ip = addslashes($_SERVER['HTTP_X_FORWARDED_FOR']);
    }
    else
    {
      $this->ip = addslashes($_SERVER['REMOTE_ADDR']);
    }
    $this->db = new guestbook_vars($path);
    $this->db->getVars();
    $this->path = $path;
    $this->template =& $this->db->template;
    $GB_PG['base_url'] = $this->db->VARS['base_url'];
  }

//
// Are they trying to make a comment on a post that actualy exists?
//

  function is_valid_id()
  {
    $this->db->query("SELECT id FROM ".LAZ_TABLE_PREFIX."_data WHERE (id = '".intval($this->id)."')");
    $this->db->fetch_array($this->db->result);
    return ($this->db->record) ? true : false;
  }

//
// Generate the comments form if thats what we want to do
//

  function comment_form()
  {
    global $GB_UPLOAD, $GB_PG, $gbsession, $rid, $uid, $included; //, $include_path;
    if (($this->db->VARS['disablecomments'] != 1) && ((!empty($_GET['gbsession'])) && (!empty($_GET['uid']))))
    {
      $GB_PG['comment'] = $GB_PG['comment'].'?gbsession='.$gbsession.'&amp;rid='.$rid.'&amp;uid='.$uid.'&amp;included='.$included;
    }
    $this->db->query("SELECT x.*, y.p_filename, y.width, y.height, z.comments from ".LAZ_TABLE_PREFIX."_data x left join ".LAZ_TABLE_PREFIX."_pics y on (x.id=y.msg_id and y.book_id=2) left join ".LAZ_TABLE_PREFIX."_com z on (x.id=z.id) WHERE (x.accepted='1' AND x.id=".intval($this->id).") LIMIT 1");
    $row = $this->db->fetch_array($this->db->result);
    $LANG =& $this->db->LANG;
    $VARS =& $this->db->VARS;
    if (isset($_COOKIE['lang']) && !empty($_COOKIE['lang']) && file_exists(LAZ_INCLUDE_PATH.'/lang/codes-'.$_COOKIE['lang'].'.php'))
    {
      $LANG_CODES = $GB_PG['base_url'].'/lang/codes-'.$_COOKIE['lang'].'.php';
    }
    elseif (file_exists(LAZ_INCLUDE_PATH.'/lang/codes-'.$VARS['lang'].'.php'))
    {
      $LANG_CODES = $GB_PG['base_url'].'/lang/codes-'.$VARS['lang'].'.php';
    }
    else
    {
      $LANG_CODES = $GB_PG['base_url'].'/lang/codes-english.php';
    }
    $antispam = $this->db->VARS['antispam_word'];
    $HTML_CODE = ($this->db->VARS['allow_html'] == 1) ? $this->db->LANG['BookMess2'] : $this->db->LANG['BookMess1'];
    $AG_CODE = ($this->db->VARS['agcode'] == 1) ? '<a href="'.$LANG_CODES.'?show=agcode" onclick="openCentered(\''.$LANG_CODES.'?show=agcode\',\'_codes\',640,450,\'scrollbars=yes\')" target="_codes">'.$this->db->LANG['FormMess3'].'</a>' : $this->db->LANG['FormMess6'];
    $SMILE_CODE = $this->db->LANG['FormMess7'];
    $DATE = $this->db->DateFormat($row['date']);
    $MESSAGE = nl2br($row['comment']);
    $id = $this->id;
    $bgcolor = $this->db->VARS['tb_color_1'];
    $COMMENT ='';
    if ($row['p_filename'] && preg_match('/^img-/',$row['p_filename']))
    {
      $img = new gb_image();
      $img->set_border_size($this->db->VARS['img_width'], $this->db->VARS['img_height']);
      $new_img_size = $img->get_img_size_format($row['width'], $row['height']);
      $row['p_filename2'] = $row['p_filename'];
      if (file_exists($this->path.'/'.$GB_UPLOAD.'/t_'.$row['p_filename']))
      {
        $row['p_filename2'] = 't_'.$row['p_filename2'];
      }      
      eval("\$USER_PIC = \"".$this->template->get_template('user_pic')."\";");
    }
    else
    {
      $USER_PIC = '';
    }
    if ($this->db->VARS['smilies'] == 1)
    {
      $MESSAGE = $this->db->emotion($MESSAGE);
      $LAZSMILEYS = $this->db->generate_smilies();
    }
    if ($row['url'] && ($this->db->VARS['allow_url'] == 1))
    {
      eval("\$URL = \"".$this->template->get_template('url')."\";");
    }
    else
    {
      $URL = '';
    }
    if ($row['location'] && ($this->db->VARS['allow_loc'] == 1))
    {
      eval("\$LOCATION = \"".$this->template->get_template('location')."\";");
    }
    else
    {
      $LOCATION = '';
    }    
    if ($row['icq'] && ($this->db->VARS['allow_icq'] == 1))
    {
      eval("\$ICQ = \"".$this->template->get_template('icq')."\";");
    }
    else
    {
      $ICQ = '';
    }
    if ($row['aim'] && ($this->db->VARS['allow_aim'] == 1))
    {
      eval("\$AIM = \"".$this->template->get_template('aim')."\";");
    }
    else
    {
      $AIM = '';
    }
    if ($row['msn'] && ($this->db->VARS['allow_msn'] == 1))
    {
      eval("\$MSN = \"".$this->template->get_template('msn')."\";");
    }
    else
    {
      $MSN = '';
    }
    if ($row['yahoo'] && ($this->db->VARS['allow_yahoo'] == 1))
    {
      eval("\$YAHOO = \"".$this->template->get_template('yahoo')."\";");
    }
    else
    {
      $YAHOO = '';
    }
    if ($row['skype'] && ($this->db->VARS['allow_skype'] == 1))
    {
      eval("\$SKYPE = \"".$this->template->get_template('skype')."\";");
    }
    else
    {
      $SKYPE = '';
    }    
    if ($row['email'] && ($this->db->VARS['require_email'] < 2))
    {
      if ($this->db->VARS['encrypt_email'] == 1)
      {
        $TEXTEMAIL = $this->db->html_encode($row['email']);
        $MAILTO = $this->db->html_encode('mailto:').$TEXTEMAIL;
        $TEXTEMAIL = str_replace('&#64;', '<b>&#64;</b>', $TEXTEMAIL);
        $TEXTEMAIL = str_replace('&#x40;', '<b>&#x40;</b>', $TEXTEMAIL);
        $TEXTEMAIL = str_replace('&#46;', '<b>&#46;</b>', $TEXTEMAIL);
        $TEXTEMAIL = str_replace('&#x2e;', '<b>&#x2e;</b>', $TEXTEMAIL);
        $TEXTEMAIL = str_replace('@', '<b>&#46;</b>', $TEXTEMAIL);
        $TEXTEMAIL = str_replace('.', '<b>&#x40;</b>', $TEXTEMAIL); 
      }
      else
      {
        $MAILTO = "mailto:$row[email]";
        $TEXTEMAIL = $row['email'];
      }
      eval("\$EMAIL = \"".$this->template->get_template('email')."\";");
    }
    else
    {
      $EMAIL = '';
      $TEXTEMAIL = '';
    }
    if ($this->db->VARS['allow_gender'] == 1)
    {
      if ($row['gender'] == 'f')
      {
        eval("\$GENDER = \"".$this->template->get_template('img_female')."\";");
      }
      elseif ($row['gender'] == 'm')
      {
        eval("\$GENDER = \"".$this->template->get_template('img_male')."\";");
      }
      else
      {
        $GENDER = '';
      }
    }
    else
    {
      $GENDER = '';
    }
    if ($this->db->VARS['show_ip'] == 1)
    {
      $hostname = (preg_match('/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/', $row['host']) ) ? 'IP' : 'Host';
      $HOST = '<em style="font-weight: normal;">'.$hostname.': '.$row['host']."</em>\n";
    }
    else
    {
      $HOST='';
    }
    $TIMEHASH = $this->db->generate_timehash();
    $TimehashTag = '<input type="hidden" name="gb_timehash" value="'.$TIMEHASH.'" />';
    $EXTRAJS = '';
    if ($this->db->VARS['need_pass'] == 1)
    {
      $com_question = ($this->db->VARS['com_question'] != '') ? $this->db->VARS['com_question']."<br />\n" : '';
      eval("\$COMMENT_PASS = \"".$this->template->get_template('com_pass')."\";");
    }
    elseif ($this->db->VARS['need_pass'] == 2)
    {
      $EXTRAJS .= 'function checkForm() {
       document.book.gb_bottest.value=trim(document.book.gb_bottest.value);
       if(document.book.gb_bottest.value == "") {
         alert("'.$LANG['ErrorPost13'].'");
         document.book.gb_bottest.focus();
         return false;
       }
       flag=1;
      return true;
      }';
      eval("\$COMMENT_PASS = \"".$this->template->get_template('form_captcha')."\";");
    }
    else
    {
      $COMMENT_PASS = '';
    }
    $GB_COMMENT = '#';
    $GB_ENTRY = '';
    $EMAILJS = '';
    $display_tags = $this->db->create_buttons($LANG_CODES);
    if ($row['comments'])
    {
      $this->db->query("SELECT * FROM ".LAZ_TABLE_PREFIX."_com WHERE id='".intval($this->id)."' AND comaccepted='1' order by com_id asc");
      while ($com = $this->db->fetch_array($this->db->result))
      {
        $COMDATE = $this->db->DateFormat($com['timestamp']);
        $comhostname = (preg_match('/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/', $com['host'])) ? 'IP' : 'Host';
        $comhost = ($this->db->VARS['show_ip'] == 1) ? '<i>'.$comhostname.': '.$com['host']."</i><br />\n" : '';
        $com['comments'] = ($this->db->VARS['smilies'] == 1) ? nl2br($this->db->emotion($com['comments'])) : nl2br($com['comments']);
        eval("\$COMMENT .= \"".$this->template->get_template('com')."\";");
      }
    }     
    $theirbrowser = $this->db->browser_detect($row['browser']);
    $comment_html = '';
    $COMMENTLINK = '';
    $PERMALINK = '';
    eval("\$GB_ENTRY = \"".$this->template->get_template('entry')."\";");
    $GB_ENTRY .= $TimehashTag;
    eval("\$comment_html = \"".$this->template->get_template('header')."\";");
    eval("\$comment_html .= \"".$this->template->get_template('comment')."\";");
    eval("\$comment_html .= \"".$this->template->get_template('footer')."\";");
    return $comment_html;
  }


//
// Check the submitted comment to make sure it's nice an clean and do some formatting
//

  function check_comment()
  {
    $the_time = time();
    $this->comment = $this->db->FormatString($this->comment);
    if (empty($this->comment))
    {
      return $this->db->gb_error($this->db->LANG['ErrorPost11']);
    }
    $this->user = $this->db->FormatString($this->user);
    if (empty($this->user))
    {
      return $this->db->gb_error($this->db->LANG['ErrorPost1']);
    }
    if (empty($this->timehash))
    {
      return $this->db->gb_error($this->db->LANG['ErrorPost4']);
    }
    if (($this->db->VARS['need_pass'] == 1) && empty($this->pass_comment)) 
    {
      return $this->db->gb_error($this->db->LANG['ErrorPost13']);
    }
    if (($this->db->VARS['need_pass'] == 2) && empty($this->bottest)) 
    {
      return $this->db->gb_error($this->db->LANG['ErrorPost13']);
    }
    if (!$this->db->CheckWordLength($this->user))
    {
      return $this->db->gb_error($this->db->LANG['ErrorPost4']);
    }
    if (!$this->db->CheckWordLength($this->comment))
    {
      return $this->db->gb_error($this->db->LANG['ErrorPost10']);
    }
    $this->comment = htmlspecialchars($this->comment);
    if ($this->db->VARS['censor'] == 1)
    {
      $this->user = $this->db->CensorBadWords($this->user);
      $this->comment = $this->db->CensorBadWords($this->comment);
    } 
    if ($this->db->VARS['censor'] == 2)
    {
      if ($this->db->BlockBadWords($this->user) || $this->db->BlockBadWords($this->comment))
      {
        return $this->db->gb_error($this->db->LANG['ErrorPost10']);
      }
    }
    if ($this->db->VARS['max_url'] < 99)
    {
      if ($this->db->urlCounter($this->comment) > $this->db->VARS['max_url'])
      {
        return $this->db->gb_error($this->db->LANG['ErrorPost10']);
      }
    }        
    if ($this->db->VARS['allow_html'] == 1)
    {
      $this->comment = $this->db->allowed_html($this->comment);
    }
    if ($this->db->VARS['agcode'] == 1)
    {
      $this->comment = $this->db->AGCode($this->comment);
    }
    $this->user = htmlspecialchars($this->user);
    if ($this->db->VARS['need_pass'] == 1)
    {
      if (strtolower($this->db->VARS['comment_pass']) != strtolower($this->pass_comment))
      {
        return $this->db->gb_error($this->db->LANG['PassMess3']);
      }
    }
    if (($this->db->VARS['need_pass'] == 2) && (!$this->db->captcha_test($this->bottest, $this->timehash)))
    {
      return $this->db->gb_error($this->db->LANG['ErrorPost14']);
    }    
    if ($this->db->VARS['flood_check'] == 1 )
    {
      if ($this->db->FloodCheck($this->ip))
      {
        return $this->db->gb_error($this->db->LANG['ErrorPost8']);
      }
    }
    if ($this->db->VARS['banned_ip'] == 1)
    {
      if ($this->db->isBannedIp($this->ip))
      {
        return $this->db->gb_error($this->db->LANG['ErrorPost9']);
      }
    }
    $decodedhash = $this->db->generate_timehash($this->timehash);
    if (($the_time < ($decodedhash + $this->db->VARS['post_time_min'])) && ($this->db->VARS['post_time_min'] != 0))
    {
      return $this->db->gb_error($this->db->LANG['ErrorPost15']);
    }
    if (($the_time > ($decodedhash + $this->db->VARS['post_time_max'])) && ($this->db->VARS['post_time_max'] != 0))
    {
      return $this->db->gb_error($this->db->LANG['ErrorPost16']);
    }    
    return 1;
  }

//
// Insert the formatted comment into our database
//

  function insert_comment()
  {
    global $GB_PG;
    $the_time = time();
    $LANG =& $this->db->LANG;
    if (get_magic_quotes_gpc())
    {
      $this->user = stripslashes($this->user);
      $this->comment = stripslashes($this->comment);
      $this->bottest = stripslashes($this->bottest);
      $this->db->VARS['bottestanswer'] = stripslashes($this->db->VARS['bottestanswer']);
      $this->db->VARS['comment_pass'] = stripslashes($this->db->VARS['comment_pass']);
      $this->timehash = stripslashes($this->timehash);
      $this->pass_comment = stripslashes($this->pass_comment);
    }
    $this->user = mysql_real_escape_string($this->user);
    //$this->comment = mysql_real_escape_string($this->comment);
    $this->bottest = mysql_real_escape_string($this->bottest);
    $this->db->VARS['bottestanswer'] = mysql_real_escape_string($this->db->VARS['bottestanswer']);
    $this->db->VARS['comment_pass'] = mysql_real_escape_string($this->db->VARS['comment_pass']);
    $this->timehash = mysql_real_escape_string($this->timehash);
    $this->pass_comment = mysql_real_escape_string($this->pass_comment);
    $host = mysql_real_escape_string(htmlspecialchars(@gethostbyaddr($this->ip)));
    $this->accepted = 1;
    if ($this->db->VARS['require_comchecking'] == 1)
    {
      $this->accepted = 0;
    }
    if ($this->db->VARS['censor'] == 4)
    {
      if ($this->db->BlockBadWords($this->user) || $this->db->BlockBadWords($this->comment))
      {
        $this->accepted = 0;
      }
    }
    $this->db->query("INSERT INTO ".LAZ_TABLE_PREFIX."_com (id,name,comments,host,timestamp,comaccepted,ip) VALUES ('$this->id','$this->user','".mysql_real_escape_string($this->comment)."','$host','$the_time','$this->accepted','$this->ip')");
    $entry_id = mysql_insert_id();
    $this->db->query("SELECT x.*, z.comments from ".LAZ_TABLE_PREFIX."_data x left join ".LAZ_TABLE_PREFIX."_com z on (x.id=z.id) WHERE (x.id=".intval($this->id).") LIMIT 1");
    $original = $this->db->fetch_array($this->db->result);
    $prev_comments = '';
    $prev_coms = '';
    if ($original['comments'])
    {
      $this->db->query("SELECT * FROM ".LAZ_TABLE_PREFIX."_com WHERE id='".intval($this->id)."' AND comaccepted='1' order by com_id asc");
      while ($com = $this->db->fetch_array($this->db->result))
      {
        $prev_coms[] = "<br>\n<br>\n<b>".$com['name'].":</b><br>\n".$com['comments'];;
      }
      if(is_array($prev_coms) && (count($prev_coms) > 1))
      {
        array_pop($prev_coms);
        $prev_comments = implode('', $prev_coms);
      }
      else
      {
        $prev_comments = '';
      }
    }
    $hostname = ( preg_match('/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/', $host) ) ? 'IP' : 'Host';
    $messagebody = $LANG['FormName'].': '.$this->user."<br />\n";
    $messagebody .= $hostname.': '.$host."<br />\n<br />\n";
    $messagebody .= $LANG['EmailMess2'].":<br />\n".nl2br($this->comment)."<br>\n<br>\n";
    $messagebody .= $LANG['EmailMess1'].":<br />\n<br />\n<b>".$original['name'].":</b><br>\n".$original['comment']."<br />\n<br />\n";
    if (!empty($prev_comments))
    {
      $messagebody .= $LANG['BookMess7'].$prev_comments."<br>\n<br>\n";
    }
    if ($GB_PG['base_url'] != '')
    {
      $messagebody .= "<br />\n<br />\n";
      $messagebody .= ($this->accepted == 0) ? $LANG['AdminAccept'].': <a href="'.$GB_PG['admin'].'?action=accept&tbl=com&id='.$entry_id.'">'.$GB_PG['admin'].'?action=accept&tbl=com&id='.$entry_id."</a><br />\n" : $LANG['AdminUnaccept'].': <a href="'.$GB_PG['admin'].'?action=unaccept&tbl=com&id='.$entry_id.'">'.$GB_PG['admin'].'?action=unaccept&tbl=com&id='.$entry_id."</a><br />\n"; 
      $messagebody .= $LANG['AdminEdit'].': <a href="'.$GB_PG['admin'].'?action=edit&tbl=com&id='.$entry_id.'">'.$GB_PG['admin'].'?action=edit&tbl=com&id='.$entry_id."</a><br />\n";
      $messagebody .= $LANG['AdminDelete'].': <a href="'.$GB_PG['admin'].'?action=del&tbl=com&id='.$entry_id.'">'.$GB_PG['admin'].'?action=del&tbl=com&id='.$entry_id."</a><br />\n";
      $messagebody .= $LANG['FormSelect'].': <a href="'.$this->db->VARS['laz_url'].'">'.$this->db->VARS['laz_url']."</a><br>\n";
    }    
    $messagebody = stripslashes($messagebody);
    if (($this->db->VARS['notify_admin_com'] == 1) || ($this->db->VARS['require_comchecking'] == 1))
    {
      $admin_emails = explode(',', $this->db->VARS['admin_mail']);
      foreach ($admin_emails as $adminsaddy)
      {
        $adminsaddy = trim($adminsaddy);
        if ($this->db->check_emailaddress($adminsaddy))
        {
          if ($this->db->VARS['always_bookemail'] && !empty($this->db->VARS['book_mail']))
          {
            $this->db->send_email($adminsaddy,$this->db->LANG['EmailAdminComSubject'],$messagebody, 'From: "'.$this->user.'" <'.$this->db->VARS['book_mail'].'>', $this->db->VARS['book_mail']);
          }
          else
          {
            $this->db->send_email($adminsaddy,$this->db->LANG['EmailAdminComSubject'],$messagebody, 'From: "'.$this->user.'" <'.$adminsaddy.'>', $adminsaddy);
          }
        }
      }
    }
    $this->db->query("INSERT INTO ".LAZ_TABLE_PREFIX.'_ip'." (guest_ip,timestamp) VALUES ('$this->ip','$the_time')");
  }

  function comment_action($action = '')
  {
    global $GB_PG, $IS_INCLUDE, $gbsession, $uid, $rid, $included;
    if ($this->id && $this->is_valid_id() && $action == 1)
    {
      $status = $this->check_comment();
      if ($status == 1)
      {
        $this->insert_comment();
        $LANG =& $this->db->LANG;
        $VARS =& $this->db->VARS;
        $success_message = $LANG['BookMess10'];
        if ($this->accepted == 0)
        {
          $success_message = $LANG['BookMess11'];
        }
        if(($this->db->VARS['disablecomments'] != 1) && ((!empty($_GET['gbsession'])) && (!empty($_GET['uid']))))
        {
          $GB_PG['index'] = $GB_PG['admin'].'?action=show&amp;tbl=gb&amp;gbsession='.$gbsession.'&amp;rid='.$rid.'&amp;uid='.$uid.'&amp;included='.$included;
        }
        define('IS_SUCCESS', true);
        $success_html = '';
        eval("\$success_html .= \"".$this->template->get_template('success_header')."\";");
        eval("\$success_html .= \"".$this->template->get_template('success')."\";");
        eval("\$success_html .= \"".$this->template->get_template('footer', false)."\";");
        echo $success_html;
      }
      else
      {
        echo $status;
      }
    }
    elseif ($this->id && $this->is_valid_id())
    {
      echo $this->comment_form();
    }
    else
    {
      if (IS_INCLUDE)
      {
        echo ("<META HTTP-EQUIV=Refresh CONTENT=\"0; URL=".$GB_PG['index']."\">");
      }
      else
      {
        header("Location: $GB_PG[index]");
      }
    }
  }

}

?>